/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWException;
import filenet.vw.base.SaxParseDBExecConn;
import filenet.vw.base.SaxParseDBExecConnHandle;
import filenet.vw.base.logging.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLHelper {
    protected static Logger logger = Logger.getLogger("filenet.vw.base");
    protected static final String m_className = "XMLHelper";
    protected static Class DocumentBuilderFactoryClass = null;
    private static final int NPATTERNS = 8;
    private static final String[] XML_ENCODED_PATTERNS;
    private static final int[] XML_ENCODED_LEN;
    private static char[] XML_ENCODED_CHARS;
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected static final String LOAD_EXTERNAL_DTD_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String NAMESPACE_PREFIX_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String VALIDATION_DYNAMIC_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";

    public static String _get_FILE_DATE() {
        return "$Date:   09 Oct 2007 12:09:50  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.16  $";
    }

    public static void establishThreadContextClassLoader() {
        String m_method = "establishThreadContextClassLoader";
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, "establishThreadContextClassLoader", "contextClassLoader is NULL!!!!");
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(XMLHelper.class.getClassLoader());
                        return null;
                    }
                });
                contextClassLoader = Thread.currentThread().getContextClassLoader();
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "establishThreadContextClassLoader", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDocumentViaDOM(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, boolean validate) throws IOException, SAXException, VWException, NumberFormatException {
        String m_method = "parseDocumentViaDOM";
        logger.entering(m_className, "parseDocumentViaDOM");
        try {
            Document document = XMLHelper.parseDocumentViaDOM(inputSource, entityResolver, errorHandler, validate, true);
            Object var7_6 = null;
            logger.exiting(m_className, "parseDocumentViaDOM");
            return document;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            logger.exiting(m_className, "parseDocumentViaDOM");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parseDocumentViaDOM(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, boolean validate, boolean namespaceAware) throws IOException, SAXException, VWException, NumberFormatException {
        String m_method = "parseDocumentViaDOM";
        DocumentBuilderFactory dbf = null;
        DocumentBuilder parser = null;
        try {
            XMLHelper.establishThreadContextClassLoader();
            if (DocumentBuilderFactoryClass != null) {
                dbf = (DocumentBuilderFactory)DocumentBuilderFactoryClass.newInstance();
            }
            if (dbf == null) {
                dbf = DocumentBuilderFactory.newInstance();
            }
            dbf.setNamespaceAware(namespaceAware);
            parser = dbf.newDocumentBuilder();
            if (inputSource == null) {
                return null;
            }
            if (validate) {
                dbf.setValidating(true);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "parseDocumentViaDOM", e);
            throw new VWException("filenet.vw.base.XMLHelper.NoDOMParser", "Failed to get a document parser. {0}", e.getLocalizedMessage());
        }
        try {
            try {
                Document doc;
                if (entityResolver != null) {
                    parser.setEntityResolver(entityResolver);
                }
                if (errorHandler == null) return doc;
                parser.setErrorHandler(errorHandler);
                doc = parser.parse(inputSource);
                return doc;
            }
            catch (SAXParseException ex) {
                logger.throwing(m_className, "parseDocumentViaDOM", ex);
                throw new VWException("filenet.vw.base.XMLHelper.ParserException", "Parse error (line {0}). {1}", Integer.toString(ex.getLineNumber()), ex.getLocalizedMessage());
            }
            catch (Throwable t) {
                logger.throwing(m_className, "parseDocumentViaDOM", t);
                throw new VWException("filenet.vw.base.XMLHelper.NoDOMParser", "Failed to parse. {0}", t.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            throw throwable;
        }
    }

    public static Document newDocumentViaDOM() throws VWException {
        try {
            XMLHelper.establishThreadContextClassLoader();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.newDocument();
        }
        catch (Exception e) {
            throw new VWException("filenet.vw.base.XMLHelper.CannotGetNewDOMDocument", "Failed to get a new DOM document. {0}", e.getLocalizedMessage());
        }
    }

    public static String toXMLString(String buf) {
        int i;
        if (buf == null) {
            return "";
        }
        boolean specialChar = false;
        for (i = 0; i < buf.length() && !specialChar; ++i) {
            switch (buf.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    specialChar = true;
                }
            }
        }
        if (!specialChar) {
            return buf;
        }
        StringBuffer sb = new StringBuffer();
        block14: for (i = 0; i < buf.length(); ++i) {
            switch (buf.charAt(i)) {
                case '&': {
                    sb.append("&amp;");
                    continue block14;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block14;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block14;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block14;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block14;
                }
                case '\n': {
                    sb.append("&#10;");
                    continue block14;
                }
                case '\r': {
                    sb.append("&#13;");
                    continue block14;
                }
                case '\t': {
                    sb.append("&#09;");
                    continue block14;
                }
                default: {
                    sb.append(buf.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public static String convertXMLChars(String buf) {
        if (buf == null) {
            return "";
        }
        boolean foundIt = false;
        for (int i = 0; i < 8 && !foundIt; ++i) {
            foundIt = buf.indexOf(XML_ENCODED_PATTERNS[i]) != -1;
        }
        if (!foundIt) {
            return buf;
        }
        StringBuffer sb = new StringBuffer();
        block1: for (int j = 0; j < buf.length(); ++j) {
            if (buf.charAt(j) == '&') {
                for (int i = 0; i < 8; ++i) {
                    if (!buf.startsWith(XML_ENCODED_PATTERNS[i], j)) continue;
                    j += XML_ENCODED_LEN[i];
                    sb.append(XML_ENCODED_CHARS[i]);
                    continue block1;
                }
                continue;
            }
            sb.append(buf.charAt(j));
        }
        return sb.toString();
    }

    public static String getNamespaceFromNodeName(String nodeName) {
        int nIndex;
        String namespace = "";
        if (nodeName != null && nodeName.length() > 0 && (nIndex = nodeName.indexOf(":")) != -1) {
            namespace = nodeName.substring(0, nIndex + 1);
        }
        return namespace;
    }

    public static byte[] DOMDocToUTF8ByteArray(Document doc) throws Exception {
        String method = "DOMDocToUTF8String";
        if (doc == null) {
            return null;
        }
        OutputFormat format = new OutputFormat(doc);
        format.setEncoding(DEFAULT_ENCODING);
        format.setIndenting(true);
        ByteArrayOutputStream bbuf = new ByteArrayOutputStream(1024);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)bbuf, DEFAULT_ENCODING);
        XMLSerializer serial = new XMLSerializer((Writer)out, format);
        try {
            serial.asDOMSerializer();
            serial.serialize(doc);
        }
        catch (IOException ex) {
            logger.throwing(m_className, method, ex);
            throw ex;
        }
        out.close();
        byte[] res = bbuf.toByteArray();
        return res;
    }

    public static Document XMLToDOMDOC(String xml) {
        String method = "XMLToDOMDOC";
        if (xml == null) {
            return null;
        }
        try {
            String s = null;
            int idx = xml.indexOf("<?xml");
            if (idx != -1) {
                s = xml;
            } else {
                String rootElementName = "tempRoot";
                if (xml.indexOf("<" + rootElementName + ">") == -1) {
                    s = "<" + rootElementName + ">" + xml.replaceAll("\n", "") + "</" + rootElementName + ">";
                }
            }
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(s)), null, null, false, false);
            return doc;
        }
        catch (Throwable t) {
            logger.throwing(m_className, method, t);
            return null;
        }
    }

    public static Document XMLFileToDOMDOC(String xmlFile) {
        String method = "XMLFileToDOMDOC";
        if (xmlFile == null) {
            return null;
        }
        try {
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(xmlFile)), DEFAULT_ENCODING)), null, null, false, false);
            return doc;
        }
        catch (Throwable t) {
            logger.throwing(m_className, method, t);
            return null;
        }
    }

    private static String To8HexString(int j) {
        String s = Integer.toHexString(j = Math.abs(j)).toUpperCase();
        int n0s = 8 - s.length();
        if (n0s > 0) {
            StringBuffer buf = new StringBuffer();
            while (n0s-- > 0) {
                buf.append('0');
            }
            buf.append(s);
            s = buf.toString();
        }
        return s;
    }

    public static String DisplayUTF8ArrayInHex(byte[] bArr, String encoding) throws Exception {
        byte[] b16Arr = new byte[16];
        StringBuffer buf = new StringBuffer();
        int i = 0;
        int j = 0;
        while (j < bArr.length) {
            int k;
            if (i == 0) {
                buf.append(XMLHelper.To8HexString(j)).append("\t");
            }
            if ((k = bArr[j] & 0xFF) <= 15) {
                buf.append("0");
            }
            buf.append(Integer.toHexString(k)).append(' ');
            b16Arr[i] = k != 10 && k != 8 && k != 13 && k != 9 ? bArr[j] : 46;
            if (++i != 16 && ++j != bArr.length) continue;
            String s16 = new String(b16Arr, encoding);
            buf.append("\t").append(s16).append("\n");
            i = 0;
        }
        return buf.toString();
    }

    private static byte[] getBytesFromFile(File f) throws Exception {
        long len = f.length();
        byte[] b = new byte[(int)len];
        FileInputStream in = new FileInputStream(f);
        in.read(b);
        in.close();
        return b;
    }

    private static void examineFile(String fileName) throws Exception {
        byte[] b = XMLHelper.getBytesFromFile(new File(fileName));
        System.out.println("------     " + fileName + "  --------------");
        System.out.println(XMLHelper.DisplayUTF8ArrayInHex(b, DEFAULT_ENCODING));
        System.out.println("-----------------------------------------");
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                XMLHelper.examineFile(args[i]);
                System.out.println("PARSING " + args[i]);
                Document doc = XMLHelper.XMLFileToDOMDOC(args[i]);
                if (doc == null) continue;
                System.out.println(XMLHelper.DisplayUTF8ArrayInHex(XMLHelper.DOMDocToUTF8ByteArray(doc), DEFAULT_ENCODING));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("------------- TRY AGAIN ------- ");
        try {
            char[] Test2 = new char[]{'a', '\uc3a5', '\ue280', '\ua0e2', 'a'};
            String ss = new String(Test2);
            System.out.println(XMLHelper.DisplayUTF8ArrayInHex(ss.getBytes(DEFAULT_ENCODING), DEFAULT_ENCODING));
            Document testDom = XMLHelper.newDocumentViaDOM();
            Element rootel = testDom.createElement("AAA");
            rootel.setAttribute("val1", ss);
            testDom.appendChild(rootel);
            rootel.appendChild(testDom.createTextNode("TEXT"));
            System.out.println(XMLHelper.DisplayUTF8ArrayInHex(XMLHelper.DOMDocToUTF8ByteArray(testDom), DEFAULT_ENCODING));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static int SaxParser(String pXMLStrIn, SaxParseDBExecConn pBase, String pName, int fMultiPartMsg, int fRaiseException, int isXMLStrInUTF8) throws VWException {
        block20: {
            pXMLStr = pXMLStrIn;
            errorCount = 0;
            valScheme = false;
            doNamespaces = false;
            doSchema = false;
            schemaFullChecking = false;
            namespacePrefixes = false;
            handler = new SaxParseDBExecConnHandle(pBase, fRaiseException);
            reader = null;
            try {
                block19: {
                    parser = null;
                    factory = SAXParserFactoryImpl.newInstance();
                    parser = factory.newSAXParser().getXMLReader();
                    parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    parser.setFeature("http://xml.org/sax/features/namespaces", doNamespaces);
                    parser.setFeature("http://apache.org/xml/features/validation/schema", doSchema);
                    parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", schemaFullChecking);
                    parser.setFeature("http://xml.org/sax/features/namespace-prefixes", namespacePrefixes);
                    parser.setContentHandler(handler);
                    parser.setErrorHandler(handler);
                    handler.setSaxParser(fMultiPartMsg == 1 ? parser : (XMLReader)null);
                    if (!valScheme) {
                        parser.setFeature("http://xml.org/sax/features/validation", false);
                    } else {
                        parser.setFeature("http://xml.org/sax/features/validation", true);
                        parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                    }
                    if (pXMLStr == null) break block19;
                    reader = new BufferedReader(new StringReader(pXMLStrIn));
                    parser.parse(new InputSource(reader));
                }
                var18_19 = null;
                ** if (reader == null) goto lbl-1000
            }
            catch (Throwable var17_27) {
                var18_22 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var17_27;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    reader.close();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block20;
                catch (SAXException ex) {
                    errorCount += 4;
                    if (fRaiseException == 1) {
                        throw new VWException(ex);
                    }
                    var18_20 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                    break block20;
                }
                catch (Throwable t) {
                    errorCount += 4;
                    if (fRaiseException == 1) {
                        throw new VWException(t);
                    }
                    var18_21 = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        if ((errorCount += handler.getErrorCount()) > 0) {
            return 0;
        }
        return 1;
    }

    static {
        try {
            XMLHelper.establishThreadContextClassLoader();
            DocumentBuilderFactoryClass = DocumentBuilderFactory.newInstance().getClass();
        }
        catch (Exception exception) {
            // empty catch block
        }
        XML_ENCODED_PATTERNS = new String[]{"&amp;", "&gt;", "&lt;", "&quot;", "&apos;", "&#10;", "&#13;", "&#09;"};
        XML_ENCODED_LEN = new int[]{4, 3, 3, 5, 5, 4, 4, 4};
        XML_ENCODED_CHARS = new char[]{'&', '>', '<', '\"', '\'', '\n', '\r', '\t'};
    }
}

